/*
Author: Radek Henys (admin@mouseviator.com)
Version: 1.0b
Last update: 26.3.2014
License: LGPL v3
*/

#pragma once

#include <Windows.h>
#include <vector>
#include "common.h"

struct EnumWindowProcInfo
{
	long m_processID;
	byte m_enumType;
	const char* windowText;
	std::vector<HWND> m_windowHandles;

	EnumWindowProcInfo() { m_processID = (long)INVALID_PROCESSID_VALUE; windowText = NULL; m_enumType = 0; }
	EnumWindowProcInfo(byte enumType) { EnumWindowProcInfo(); m_enumType = enumType; }
};

